/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.tables.IVWFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class VWBaseFieldTableModel
extends AbstractTableModel
implements IVWFieldTableModel,
IVWPropertyChangeSource {
    private static final int UPDATE_CHANGE = 0;
    private static final int UPDATE_REMOVE = 1;
    private static final int UPDATE_RENAME = 2;
    protected static final String ARRAY_SYMBOL = "[ ]";
    protected Vector m_rowData = null;
    protected VWAuthPropertyData m_authPropertyData = null;
    protected Vector m_changedItems = null;
    protected int m_nColumnIndexOffset = 1;

    public VWBaseFieldTableModel(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void copyItem(int nRowIndex) {
    }

    public abstract void deleteItem(int var1);

    public void addItem(int nRowIndex, Object aValue) {
    }

    public void sortAscending() throws Exception {
        if (this.m_rowData.size() > 0) {
            Object[] tempArray = new VWTableItemWrapper[this.m_rowData.size()];
            this.m_rowData.copyInto(tempArray);
            VWQubbleSort.sort(tempArray);
            this.m_rowData = new Vector();
            for (int i = 0; i < tempArray.length; ++i) {
                this.m_rowData.addElement(tempArray[i]);
            }
            this.fireTableDataChanged();
            int nRowIndex = this.getRowCount() - 1;
            this.fireTableRowsInserted(nRowIndex, nRowIndex);
        }
    }

    public void reinitialize() {
        this.m_nColumnIndexOffset = this.m_authPropertyData.getShowInheritedProperties() ? 0 : 1;
        if (this.m_rowData == null) {
            this.m_rowData = new Vector();
        }
        this.m_rowData.removeAllElements();
    }

    public int findIndex(String fieldName) {
        int nRowIndex = -1;
        int size = this.m_rowData.size();
        if (size > 0 && fieldName != null && fieldName.length() > 0) {
            for (int i = 0; i < size; ++i) {
                String name;
                VWFieldDefinition fieldDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(i);
                if (wrapper == null || wrapper.getValue() == null || (fieldDef = (VWFieldDefinition)wrapper.getValue()) == null || VWStringUtils.compare(fieldName, name = fieldDef.getName()) != 0) continue;
                nRowIndex = i;
                break;
            }
        }
        return nRowIndex;
    }

    public boolean canDeleteRow(int nRowIndex) {
        if (nRowIndex == this.getRowCount() - 1) {
            return false;
        }
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        if (wrapper != null) {
            return wrapper.canDelete();
        }
        return false;
    }

    public int getActualColumnIndex(int nColumnIndex) {
        return nColumnIndex - this.m_nColumnIndexOffset;
    }

    public abstract Class getColumnClass(int var1);

    public abstract int getColumnCount();

    public abstract String getColumnName(int var1);

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public abstract Object getValueAt(int var1, int var2);

    public abstract boolean isCellEditable(int var1, int var2);

    public abstract void setValueAt(Object var1, int var2, int var3);

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    protected VWTableItemWrapper getTableItemAt(int nRowIndex) {
        VWTableItemWrapper wrapper = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            wrapper = (VWTableItemWrapper)this.m_rowData.elementAt(nRowIndex);
        }
        return wrapper;
    }

    protected void overrideTableItem(int nRowIndex, Object newValue) {
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        if (wrapper != null) {
            wrapper.overrideValue(newValue);
        }
    }

    protected void onChangedField(VWFieldDefinition changedFieldDef) {
        try {
            if (changedFieldDef == null || this.m_authPropertyData == null) {
                return;
            }
            this.updateParameters(changedFieldDef.getName(), null, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onRemovedFields(Vector deletedFieldList) {
        try {
            if (deletedFieldList == null) {
                return;
            }
            for (int i = 0; i < deletedFieldList.size(); ++i) {
                if (deletedFieldList.elementAt(i) == null || !(deletedFieldList.elementAt(i) instanceof VWFieldDefinition)) {
                    System.out.println("Invalid class! " + deletedFieldList.elementAt(i));
                    return;
                }
                String name = ((VWFieldDefinition)deletedFieldList.elementAt(i)).getName();
                this.updateParameters(name, null, 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void onRenamedField(Vector names) {
        try {
            if (names != null) {
                String oldName = (String)names.elementAt(0);
                String newName = (String)names.elementAt(1);
                this.updateParameters(oldName, newName, 2);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateParameters(String name, String newName, int nUpdateType) throws VWException {
        if (this.m_authPropertyData == null) {
            return;
        }
        VWWorkflowDefinition wfDefinition = this.m_authPropertyData.getWorkflowDefinition();
        VWMapDefinition[] mapDefs = wfDefinition.getMaps();
        if (mapDefs == null) {
            return;
        }
        VWFieldDefinition changedFieldDef = null;
        if (nUpdateType == 0) {
            changedFieldDef = wfDefinition.getField(name);
        }
        for (int l = 0; l < mapDefs.length; ++l) {
            VWMapNode[] mapNodes = mapDefs[l].getSteps();
            for (int j = 0; j < mapNodes.length; ++j) {
                VWMapNode mapNode = mapNodes[j];
                if (!(mapNode instanceof VWStepDefinition)) continue;
                try {
                    VWParameterDefinition parameterDef = ((VWStepDefinition)mapNode).getParameterDefinition(name);
                    if (parameterDef == null || VWStringUtils.compare(name, parameterDef.getValue()) != 0) continue;
                    switch (nUpdateType) {
                        case 0: {
                            if (changedFieldDef == null) break;
                            parameterDef.setDataType(changedFieldDef.getFieldType());
                            parameterDef.setIsArray(changedFieldDef.isArray());
                            break;
                        }
                        case 1: {
                            ((VWStepDefinition)mapNode).deleteParameter(name);
                            break;
                        }
                        case 2: {
                            VWParameterDefinition newParamDef = ((VWStepDefinition)mapNode).createParameter(newName, parameterDef.getMode(), newName, parameterDef.getDataType(), parameterDef.getIsArray());
                            newParamDef.setDescription(parameterDef.getDescription());
                            ((VWStepDefinition)mapNode).deleteParameter(name);
                            break;
                        }
                    }
                    continue;
                }
                catch (VWException ex1) {
                    // empty catch block
                }
            }
        }
    }
}

